/****** OBJECT:  STOREDPROCEDURE [DBO].[P_CG_FND_VERBA_MOVIMENTACAO_CONTRATO]    SCRIPT DATE: 04/08/2014 09:57:57 ******/
IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_CG_FND_VERBA_MOVIMENTACAO_CONTRATO]') AND TYPE IN (N'P', N'PC'))
DROP PROCEDURE [DBO].[P_CG_FND_VERBA_MOVIMENTACAO_CONTRATO]
GO
--P_CG_FND_VERBA_MOVIMENTACAO_CONTRATO 1,2
CREATE PROCEDURE P_CG_FND_VERBA_MOVIMENTACAO_CONTRATO(@CD_EMP INT, @CD_FND_VERBA INT, @CONSULTA INT = 0) WITH ENCRYPTION
AS
BEGIN
SET NOCOUNT ON 
CREATE TABLE #RSDOCUMENTOS (
					   ORDEM INT IDENTITY (1, 1),
					   CD_EMP INT , 
					   CD_FILIAL INT, 
					   CD_FILIAL_FAT INT,
					   CD_DOCUMENTO INT,
					   CD_DOCUMENTO_CONTROLE INT,
					   TIPO_DOCUMENTO INT,
					   DS_TIPO_DOCUMENTO VARCHAR(10),
					   CD_PROD INT, 
					   DS_PROD VARCHAR(100),
					   NR_DOCUMENTO INT, 
					   DS_MOV VARCHAR (60), 
					   DT_MOV DATETIME, 
					   QT_IT MONEY, 
					   VLR_PROD_VERBA MONEY, 
					   VLR_LIMITE_VERBA MONEY,
					   VLR_VERBA_MOVIMENTO MONEY,
					   VLR_VERBA_USADA MONEY,
					   VLR_VERBA_SALDO MONEY)

DECLARE @CD_FORN INT
DECLARE @TP_CONTRATO INT

SELECT
	@CD_FORN = CD_FORN,
	@TP_CONTRATO = TP_LANC
FROM
	CG_FND_VERBA
WHERE
	CD_EMP = @CD_EMP
	AND CD_FND_VERBA = @CD_FND_VERBA

IF @TP_CONTRATO = 1
BEGIN

	CREATE TABLE #PDV_VD_IT (
		CD_EMP INT,
		CD_FILIAL INT,
		CD_VD INT,
		NR_ECF INT,
		DT_VD DATETIME,
		HR_VD DATETIME,
		CD_IT INT,
		CD_PROD INT,
		QT_IT MONEY)

	CREATE TABLE #VERBA (
		CD_FND_VERBA INT,
		CD_FILIAL_FAT INT,
		DT_INI_APURACAO DATETIME,
		DT_FIM_APURACAO DATETIME)

	CREATE TABLE #VERBA_PROD (
		CD_FND_VERBA INT,
		CD_PROD INT,
		VLR_IT MONEY,
		LIMITE_VERBA MONEY)

	CREATE TABLE #VERBA_FIL (
		CD_FND_VERBA INT,
		CD_FILIAL INT)


	INSERT INTO
		#VERBA
	SELECT
		CG_FND_VERBA.CD_FND_VERBA,
		CG_FND_VERBA.CD_FILIAL_FAT,
		CG_FND_VERBA.DT_INI_APURACAO,
		CG_FND_VERBA.DT_FIM_APURACAO
	FROM
		CG_FND_VERBA 
		INNER JOIN CG_FND_VERBA_LIB ON
			CG_FND_VERBA.CD_EMP = CG_FND_VERBA_LIB.CD_EMP
			AND CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_LIB.CD_FND_VERBA
	WHERE
		CG_FND_VERBA.TP_LANC = @CD_EMP
		AND CG_FND_VERBA.CD_FND_VERBA = @CD_FND_VERBA

	INSERT INTO
		#VERBA_PROD
	SELECT
		CG_FND_VERBA.CD_FND_VERBA,
		CG_FND_VERBA_DIARIA_PROD.CD_PROD,
		CG_FND_VERBA_DIARIA_PROD.VLR_IT,
		CG_FND_VERBA_DIARIA_PROD.LIMITE_VERBA
	
	FROM
		#VERBA CG_FND_VERBA 
		INNER JOIN CG_FND_VERBA_DIARIA_PROD ON
			CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_DIARIA_PROD.CD_FND_VERBA
		INNER JOIN CG_FND_VERBA_LIB ON
			CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_LIB.CD_FND_VERBA

	INSERT INTO
		#VERBA_FIL
	SELECT
		CG_FND_VERBA.CD_FND_VERBA,
		CG_FND_VERBA_PRC_FILIAL.CD_FILIAL
	FROM
		#VERBA CG_FND_VERBA 
		INNER JOIN CG_FND_VERBA_PRC_FILIAL ON
			CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_PRC_FILIAL.CD_FND_VERBA
		INNER JOIN CG_FND_VERBA_LIB ON
			CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_LIB.CD_FND_VERBA

	INSERT INTO
		#PDV_VD_IT
	SELECT
		PDV_VD_IT.CD_EMP,
		PDV_VD_IT.CD_FILIAL,
		PDV_VD_IT.CD_VD,
		PDV_VD.NR_ECF,
		PDV_VD.DT_VD,
		PDV_VD.HR_VD,
		PDV_VD_IT.CD_IT,
		PDV_VD_IT.CD_PROD,
		PDV_VD_IT.QT_IT
	
	FROM
		#VERBA CG_FND_VERBA
		INNER JOIN #VERBA_PROD CG_FND_VERBA_DIARIA_PROD ON
			CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_DIARIA_PROD.CD_FND_VERBA
		INNER JOIN #VERBA_FIL CG_FND_VERBA_PRC_FILIAL ON
			CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_DIARIA_PROD.CD_FND_VERBA
		INNER JOIN PDV_VD ON
			CG_FND_VERBA_PRC_FILIAL.CD_FILIAL = PDV_VD.CD_FILIAL
		INNER JOIN PDV_VD_IT ON
			PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP 
			AND PDV_VD.CD_FILIAL  = PDV_VD_IT.CD_FILIAL
			AND PDV_VD.CD_VD = PDV_VD_IT.CD_VD
			AND CG_FND_VERBA_DIARIA_PROD.CD_PROD  = PDV_VD_IT.CD_PROD
	WHERE
		PDV_VD_IT.DT_VD BETWEEN CG_FND_VERBA.DT_INI_APURACAO AND CG_FND_VERBA.DT_FIM_APURACAO
		AND PDV_VD.ST_VD = 0
		AND PDV_VD_IT.ST_IT = 1


	INSERT INTO 
		#RSDOCUMENTOS
	SELECT
		PDV_VD_IT.CD_EMP,
		PDV_VD_IT.CD_FILIAL,
		CG_FND_VERBA.CD_FILIAL_FAT,
		PDV_VD_IT.CD_VD,
		PDV_VD_IT.CD_IT,
		1,
		'SELL OUT',
		EST_PROD.CD_PROD,
		EST_PROD.DS_PROD,
		PDV_VD_IT.NR_ECF,
		'VENDAS AO CONSUMIDOR',
		PDV_VD_IT.DT_VD,
		PDV_VD_IT.QT_IT,
		CG_FND_VERBA_DIARIA_PROD.VLR_IT,
		CASE WHEN CG_FND_VERBA_DIARIA_PROD.LIMITE_VERBA > 0 THEN
			CG_FND_VERBA_DIARIA_PROD.LIMITE_VERBA
		ELSE
			999999999
		END AS LIMITE_VERBA,
		(PDV_VD_IT.QT_IT*CG_FND_VERBA_DIARIA_PROD.VLR_IT) AS VLR_VERBA_MOVIMENTO,
		(PDV_VD_IT.QT_IT*CG_FND_VERBA_DIARIA_PROD.VLR_IT) AS VLR_VERBA_USADA,
		0
	FROM
		#VERBA CG_FND_VERBA
		INNER JOIN #PDV_VD_IT PDV_VD_IT ON
			CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA.CD_FND_VERBA
		INNER JOIN EST_PROD ON
			PDV_VD_IT.CD_EMP = EST_PROD.CD_EMP AND
			PDV_VD_IT.CD_PROD = EST_PROD.CD_PROD
		INNER JOIN #VERBA_PROD CG_FND_VERBA_DIARIA_PROD ON
			CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_DIARIA_PROD.CD_FND_VERBA
			AND PDV_VD_IT.CD_PROD = CG_FND_VERBA_DIARIA_PROD.CD_PROD
		LEFT JOIN CG_FND_VERBA_GERACAO_PDV_VD_IT ON
			PDV_VD_IT.CD_EMP = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_EMP
			AND PDV_VD_IT.CD_FILIAL = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_FILIAL
			AND PDV_VD_IT.CD_VD = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_VD
			AND PDV_VD_IT.CD_IT = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_IT
			AND CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_FND_VERBA
	WHERE
		CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_EMP IS NULL

	ORDER BY
		PDV_VD_IT.DT_VD,
		PDV_VD_IT.HR_VD,
		PDV_VD_IT.CD_PROD

	DROP TABLE #VERBA
	DROP TABLE #PDV_VD_IT
	DROP TABLE #VERBA_PROD
	DROP TABLE #VERBA_FIL
	
END 

IF @TP_CONTRATO=2
BEGIN
INSERT INTO 
	#RSDOCUMENTOS
SELECT
	EST_NF_ENT_IT.CD_EMP,
	EST_NF_ENT_IT.CD_FILIAL,
	CG_FND_VERBA.CD_FILIAL_FAT,
	EST_NF_ENT_IT.CD_NF,
	EST_NF_ENT_IT.CD_PROD,
	@TP_CONTRATO,
	'SELL IN',
	EST_NF_ENT_IT.CD_PROD,
	EST_PROD.DS_PROD,
	V_EST_NF_ENT_CAB.NR_NF,
	V_EST_NF_ENT_CAB.NM_ORIG,
	EST_NF_ENT_IT.DT_ENT,
	EST_NF_ENT_IT.QT_IT,
	CG_FND_VERBA_DIARIA_PROD.VLR_IT,
	CASE WHEN CG_FND_VERBA_DIARIA_PROD.LIMITE_VERBA > 0 THEN
		CG_FND_VERBA_DIARIA_PROD.LIMITE_VERBA
	ELSE
		999999999
	END AS LIMITE_VERBA,
	(EST_NF_ENT_IT.QT_IT*CG_FND_VERBA_DIARIA_PROD.VLR_IT) AS VLR_VERBA_MOVIMENTO,
	(EST_NF_ENT_IT.QT_IT*CG_FND_VERBA_DIARIA_PROD.VLR_IT) AS VLR_VERBA_USADA,
	0
FROM
	CG_FND_VERBA 
	INNER JOIN  CG_FND_VERBA_DIARIA_PROD ON
		CG_FND_VERBA.CD_EMP = CG_FND_VERBA_DIARIA_PROD.CD_EMP AND
		CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_DIARIA_PROD.CD_FND_VERBA
	INNER JOIN CG_FND_VERBA_PRC_FILIAL ON
		CG_FND_VERBA.CD_EMP = CG_FND_VERBA_PRC_FILIAL.CD_EMP
		AND CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_PRC_FILIAL.CD_FND_VERBA
	INNER JOIN CG_FND_VERBA_LIB ON
		CG_FND_VERBA.CD_EMP = CG_FND_VERBA_LIB.CD_EMP
		AND CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_LIB.CD_FND_VERBA
	INNER JOIN EST_NF_ENT_IT ON
		EST_NF_ENT_IT.CD_EMP = CG_FND_VERBA_DIARIA_PROD.CD_EMP AND
		EST_NF_ENT_IT.CD_PROD  = CG_FND_VERBA_DIARIA_PROD.CD_PROD AND
		EST_NF_ENT_IT.CD_FILIAL  = CG_FND_VERBA_PRC_FILIAL.CD_FILIAL
	INNER JOIN V_EST_NF_ENT_CAB ON
		EST_NF_ENT_IT.CD_EMP = V_EST_NF_ENT_CAB.CD_EMP AND
		EST_NF_ENT_IT.CD_FILIAL = V_EST_NF_ENT_CAB.CD_FILIAL AND
		EST_NF_ENT_IT.CD_NF = V_EST_NF_ENT_CAB.CD_NF AND
		EST_NF_ENT_IT.DT_ENT = V_EST_NF_ENT_CAB.DT_ENT 
	INNER JOIN EST_NF_ENT_PED_CP ON
		EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_PED_CP.CD_EMP AND
		EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_PED_CP.CD_FILIAL AND
		EST_NF_ENT_IT.CD_NF = EST_NF_ENT_PED_CP.CD_NF 
	INNER JOIN EST_PED_CP ON
		EST_NF_ENT_PED_CP.CD_EMP = EST_PED_CP.CD_EMP AND
		EST_NF_ENT_PED_CP.CD_FILIAL = EST_PED_CP.CD_FILIAL AND
		EST_NF_ENT_PED_CP.CD_PED = EST_PED_CP.CD_PED 
	INNER JOIN EST_PROD ON
		EST_NF_ENT_IT.CD_EMP = EST_PROD.CD_EMP AND
		EST_NF_ENT_IT.CD_PROD = EST_PROD.CD_PROD 
	LEFT JOIN CG_FND_VERBA_GERACAO_EST_NF_ENT_IT ON
		EST_NF_ENT_IT.CD_EMP = CG_FND_VERBA_GERACAO_EST_NF_ENT_IT.CD_EMP
		AND EST_NF_ENT_IT.CD_FILIAL = CG_FND_VERBA_GERACAO_EST_NF_ENT_IT.CD_FILIAL
		AND EST_NF_ENT_IT.CD_NF = CG_FND_VERBA_GERACAO_EST_NF_ENT_IT.CD_NF
		AND EST_NF_ENT_IT.CD_PROD = CG_FND_VERBA_GERACAO_EST_NF_ENT_IT.CD_PROD
		AND CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_GERACAO_EST_NF_ENT_IT.CD_FND_VERBA
WHERE
	V_EST_NF_ENT_CAB.DT_ENT BETWEEN CG_FND_VERBA.DT_INI_APURACAO AND CG_FND_VERBA.DT_FIM_APURACAO
	AND V_EST_NF_ENT_CAB.TP_MOV = 0
	AND V_EST_NF_ENT_CAB.TP_MOV_OP_TRANSA = 0
	AND V_EST_NF_ENT_CAB.CD_FORN = @CD_FORN
	AND CG_FND_VERBA.TP_LANC = 2
	AND CG_FND_VERBA.CD_FND_VERBA = @CD_FND_VERBA
	AND CG_FND_VERBA_GERACAO_EST_NF_ENT_IT.CD_EMP IS NULL
ORDER BY
	EST_NF_ENT_IT.CD_PROD,
	EST_NF_ENT_IT.DT_ENT
END 


DECLARE @ORDEM INT
DECLARE @CD_PROD INT
DECLARE @VLR_VERBA MONEY
DECLARE @LIMITE_VERBA MONEY
DECLARE @LIMITE_VERBA_USO MONEY
DECLARE @LIMITE_VERBA_FALTA MONEY
DECLARE @CD_FND_VERBA_RECB INT

DECLARE @CD_PROD_PROC INT
DECLARE @VLR_VERBA_ATU MONEY

	DECLARE CALCVERBAFECHACELLIN CURSOR FAST_FORWARD FOR 
	SELECT 
		ORDEM,
		CD_PROD,
		VLR_VERBA_MOVIMENTO,
		VLR_LIMITE_VERBA
	FROM 
		#RSDOCUMENTOS
	ORDER BY
		CD_PROD,
		ORDEM
				
	OPEN CALCVERBAFECHACELLIN
	SET @CD_PROD_PROC=0


	FETCH NEXT FROM CALCVERBAFECHACELLIN INTO @ORDEM, @CD_PROD, @VLR_VERBA, @LIMITE_VERBA

	WHILE @@FETCH_STATUS=0
		BEGIN
			IF @CD_PROD <> @CD_PROD_PROC
				BEGIN
					SET @VLR_VERBA_ATU = 0
					SET @LIMITE_VERBA_USO = 0
				END

			SET @CD_PROD_PROC = @CD_PROD
			
			SET @LIMITE_VERBA_FALTA = @LIMITE_VERBA - @LIMITE_VERBA_USO

			IF @LIMITE_VERBA_FALTA > @VLR_VERBA AND @LIMITE_VERBA_FALTA > 0
				BEGIN
					IF @LIMITE_VERBA_FALTA > 0
						BEGIN
							IF @LIMITE_VERBA_FALTA > @VLR_VERBA
								BEGIN
									SET @VLR_VERBA_ATU = @VLR_VERBA
								END
							ELSE
							  BEGIN
									SET @VLR_VERBA_ATU = @LIMITE_VERBA_FALTA
							  END
						END
					ELSE
						BEGIN
							SET @VLR_VERBA_ATU = 0
						END

					IF @LIMITE_VERBA_FALTA > 0
						BEGIN	
							SET @LIMITE_VERBA_USO = @LIMITE_VERBA_USO + @VLR_VERBA_ATU 
					
							UPDATE
								#RSDOCUMENTOS
							SET
								VLR_VERBA_USADA = @VLR_VERBA_ATU,
								VLR_VERBA_SALDO = @LIMITE_VERBA - @LIMITE_VERBA_USO
							WHERE
								ORDEM = @ORDEM
						END
				END
			ELSE
				BEGIN
					UPDATE 
						#RSDOCUMENTOS 
					SET 
						VLR_VERBA_USADA = CASE WHEN @LIMITE_VERBA_FALTA > @LIMITE_VERBA THEN @LIMITE_VERBA ELSE @LIMITE_VERBA_FALTA END ,
						VLR_VERBA_SALDO = 0
					WHERE
						ORDEM = @ORDEM

					DELETE
						#RSDOCUMENTOS 
					WHERE 
						ORDEM > @ORDEM 
						AND CD_PROD = @CD_PROD
				END

			--PROXIMO REGISTRO
			FETCH NEXT FROM CALCVERBAFECHACELLIN INTO @ORDEM, @CD_PROD, @VLR_VERBA, @LIMITE_VERBA
		END

	--FECHANDO CURSOS
	CLOSE CALCVERBAFECHACELLIN;
	--DESALOCANDO CURSOS DA MEMORIA
	DEALLOCATE CALCVERBAFECHACELLIN;


IF @CONSULTA = 1
BEGIN
	SELECT * FROM #RSDOCUMENTOS ORDER BY CD_PROD
END
ELSE
BEGIN		

	DECLARE @CD_HIST INT

	DECLARE @CD_FILIAL INT 
	DECLARE @CD_FILIAL_FAT INT
	DECLARE @CD_DOCUMENTO INT
	DECLARE @CD_DOCUMENTO_CONTROLE INT
	DECLARE @TIPO_DOCUMENTO INT
	DECLARE @DS_TIPO_DOCUMENTO VARCHAR(10)
	DECLARE @CD_PROD_FECHA INT 
	DECLARE @DS_PROD VARCHAR(100)
	DECLARE @NR_DOCUMENTO INT 
	DECLARE @DS_MOV VARCHAR (60) 
	DECLARE @DT_MOV DATETIME 
	DECLARE @QT_IT MONEY 
	DECLARE @VLR_PROD_VERBA MONEY 
	DECLARE @VLR_LIMITE_VERBA MONEY
	DECLARE @VLR_VERBA_MOVIMENTO MONEY
	DECLARE @VLR_VERBA_USADA MONEY
	DECLARE @VLR_VERBA_SALDO MONEY
	DECLARE @VLR_VERBA_APURADO MONEY

	DECLARE RSDOCFECHA CURSOR FOR
		SELECT
			ORDEM,
			CD_EMP, 
			CD_FILIAL, 
			CD_FILIAL_FAT,
			CD_DOCUMENTO,
			CD_DOCUMENTO_CONTROLE,
			TIPO_DOCUMENTO,
			DS_TIPO_DOCUMENTO,
			CD_PROD, 
			DS_PROD,
			NR_DOCUMENTO, 
			DS_MOV, 
			DT_MOV, 
			QT_IT, 
			VLR_PROD_VERBA, 
			VLR_LIMITE_VERBA,
			VLR_VERBA_MOVIMENTO,
			VLR_VERBA_USADA,
			VLR_VERBA_SALDO
		FROM
			#RSDOCUMENTOS

	
		OPEN RSDOCFECHA

		FETCH NEXT FROM RSDOCFECHA INTO  @ORDEM, @CD_EMP, @CD_FILIAL, @CD_FILIAL_FAT, @CD_DOCUMENTO, @CD_DOCUMENTO_CONTROLE, @TIPO_DOCUMENTO, @DS_TIPO_DOCUMENTO, @CD_PROD, @DS_PROD, @NR_DOCUMENTO, @DS_MOV, @DT_MOV, @QT_IT, @VLR_PROD_VERBA, @VLR_LIMITE_VERBA, @VLR_VERBA_MOVIMENTO, @VLR_VERBA_USADA, @VLR_VERBA_SALDO

		IF @@FETCH_STATUS <> -1
		BEGIN
			
			SELECT @CD_HIST = COALESCE(MAX(CD_HIST),0) + 1 FROM CG_FND_VERBA_HIST

			INSERT INTO
				CG_FND_VERBA_HIST (CD_HIST, CD_EMP, CD_FND_VERBA, TP_HIST, DS_HIST, CD_USU, DT_HIST, HR_HIST)
			VALUES
				(@CD_HIST, @CD_EMP, @CD_FND_VERBA, 'GERACAO', 'GERACAO DE VERBA', 1, GETDATE(), GETDATE())



			SELECT @VLR_VERBA = SUM(VLR_VERBA_USADA) FROM #RSDOCUMENTOS
			SELECT @CD_FND_VERBA_RECB = COALESCE(MAX(CD_FND_VERBA_RECB),0) + 1 FROM CG_FND_VERBA_RECB WHERE CD_EMP = @CD_EMP AND CD_FND_VERBA = @CD_FND_VERBA
			
			INSERT INTO
				CG_FND_VERBA_RECB (CD_EMP, CD_FND_VERBA, CD_FND_VERBA_RECB, HIST_LANC, VLR_RECB, DT_RECEB, DT_CAD, DT_ULT_ALT, CD_USU, STATUS)
			VALUES
				(@CD_EMP, @CD_FND_VERBA, @CD_FND_VERBA_RECB, 'GERACAO DE VERBA NO CONTRATO: ' + CAST(@CD_FND_VERBA AS VARCHAR), @VLR_VERBA, CONVERT(DATE, GETDATE()), CONVERT(DATE, GETDATE()), NULL, 1, 0)


		END

		WHILE @@FETCH_STATUS <> -1
		BEGIN

			IF @TP_CONTRATO = 1 -- POR VENDA
			BEGIN					
				
				INSERT INTO
					CG_FND_VERBA_GERACAO_PDV_VD_IT (CD_EMP, CD_FND_VERBA, CD_FILIAL, CD_VD, CD_IT, QT_PROD, VLR_PROD_VERBA, VLR_PROD_VERBA_LIMITE, VLR_PROD_VERBA_MOVIMENTO, VLR_PROD_VERBA_USADA, ORDEM, VLR_PROD_VERBA_SALDO)
				VALUES
					(@CD_EMP, @CD_FND_VERBA, @CD_FILIAL, @CD_DOCUMENTO, @CD_DOCUMENTO_CONTROLE, @QT_IT, @VLR_VERBA_USADA, @VLR_LIMITE_VERBA, @VLR_VERBA_MOVIMENTO, @VLR_VERBA_USADA, @ORDEM, @VLR_VERBA_SALDO)

				INSERT INTO
					CG_FND_VERBA_RECB_CG_FND_VERBA_GERACAO_PDV_VD_IT(CD_EMP, CD_FND_VERBA, CD_FILIAL, CD_VD, CD_IT, CD_FND_VERBA_RECB)
				VALUES
					(@CD_EMP, @CD_FND_VERBA, @CD_FILIAL, @CD_DOCUMENTO, @CD_DOCUMENTO_CONTROLE, @CD_FND_VERBA_RECB)

			END

			ELSE --ENTRADA DE NOTA
			BEGIN
				INSERT INTO
					CG_FND_VERBA_GERACAO_EST_NF_ENT_IT (CD_EMP, CD_FND_VERBA, CD_FILIAL, CD_NF, CD_PROD, QT_PROD, VLR_PROD_VERBA, VLR_PROD_VERBA_LIMITE, VLR_PROD_VERBA_MOVIMENTO, VLR_PROD_VERBA_USADA, ORDEM, VLR_PROD_VERBA_SALDO)
				VALUES
					(@CD_EMP, @CD_FND_VERBA, @CD_FILIAL, @CD_DOCUMENTO, @CD_DOCUMENTO_CONTROLE, @QT_IT, @VLR_VERBA_USADA, @VLR_LIMITE_VERBA, @VLR_VERBA_MOVIMENTO, @VLR_VERBA_USADA, @ORDEM, @VLR_VERBA_SALDO)


				INSERT INTO
					CG_FND_VERBA_RECB_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT(CD_EMP, CD_FND_VERBA, CD_FILIAL, CD_NF, CD_PROD, CD_FND_VERBA_RECB)
				VALUES
					(@CD_EMP, @CD_FND_VERBA, @CD_FILIAL, @CD_DOCUMENTO, @CD_DOCUMENTO_CONTROLE, @CD_FND_VERBA_RECB)
			END
			
			FETCH NEXT FROM RSDOCFECHA INTO  @ORDEM, @CD_EMP, @CD_FILIAL, @CD_FILIAL_FAT, @CD_DOCUMENTO, @CD_DOCUMENTO_CONTROLE, @TIPO_DOCUMENTO, @DS_TIPO_DOCUMENTO, @CD_PROD, @DS_PROD, @NR_DOCUMENTO, @DS_MOV, @DT_MOV, @QT_IT, @VLR_PROD_VERBA, @VLR_LIMITE_VERBA, @VLR_VERBA_MOVIMENTO, @VLR_VERBA_USADA, @VLR_VERBA_SALDO
		END


		CLOSE RSDOCFECHA
		DEALLOCATE RSDOCFECHA

END

DROP TABLE #RSDOCUMENTOS
RETURN

END
